/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommonResourceBundle {
    private static final String TRACE_MASKT = "XFRMREST";
    private static final String TRACE_MASKF = "XFRMRESF";
    private static final String TRACE_MASKD = "XFRMRESD";
    public static final String COMMON_BUNDLE_NAME = "com/ibm/hwmca/fw/res/common";
    private ResourceBundle resBundle;
    private static Hashtable cache = new Hashtable();

    public static String getBundleName() {
        return COMMON_BUNDLE_NAME;
    }

    private static synchronized ResourceBundle getBundle(String name, Locale locale) {
        String key = name + locale.toString();
        ResourceBundle bundle = (ResourceBundle)cache.get(key);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(name, locale);
            cache.put(key, bundle);
        }
        return bundle;
    }

    public static String getString(String bundleName, Locale locale, String key) {
        String result;
        try {
            result = CommonResourceBundle.getBundle(bundleName, locale).getString(key);
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "Ignoring MissingResourceException trying to get key \"" + key + "\" in resource bundle " + bundleName + " for locale " + locale);
            result = key;
        }
        return result;
    }

    public CommonResourceBundle() {
        this(CommonResourceBundle.getBundleName());
    }

    public CommonResourceBundle(Locale locale) {
        this(CommonResourceBundle.getBundleName(), locale);
    }

    public CommonResourceBundle(String bundle) {
        this(bundle, Locale.getDefault());
    }

    public CommonResourceBundle(String bundle, Locale locale) {
        this.resBundle = CommonResourceBundle.getBundle(bundle, locale);
        Trace.trace(TRACE_MASKF, "<> CommonResourceBundle using bundle " + bundle + " in locale " + locale);
    }

    public String getString(String key) {
        String string = null;
        try {
            if (this.resBundle != null) {
                string = this.resBundle.getString(key);
            }
        }
        catch (MissingResourceException exc) {
            Trace.trace(TRACE_MASKF, "getString() caught MissingResourceException trying to get key " + key);
            string = key;
        }
        return string;
    }
}

